##setup packages###
library(caper)
require(devtools)
library(geiger)
library(adephylo)


tree = read.nexus("hominin.phylogney.txt")
tree<-drop.tip(tree,tip="Ardipithecus_ramidus")
data = read.csv("data set 1.csv", header=T)

#hominin data
sub.tree<-extract.clade(tree,getMRCA(tree,as.character(data[c(225,227:231,232,233:235),"Species"])))
divergence.times<-distRoot(sub.tree,as.character(data[c(225,227:231,233:235),1]))
hominin.data<-data.frame(data[c(225,227:231,233:235),c("Species","Log.ECV")],divergence.times,NA)
colnames(hominin.data)<-c("Species","ECV","divergence.times","ECV.deviation")

#run for distance between observed and mean BayesModelS prediction

preds<-read.csv("hominins.removed.log.ecv.log.body.mass.female.predictions.csv")
preds<-preds[,-1]


#re-order following when using results from alt tree
hominin.data[1,4]<-hominin.data[1,2]-mean(preds$Australopithecus_africanus)
hominin.data[2,4]<-hominin.data[2,2]-mean(preds$Homo_erectus)
hominin.data[3,4]<-hominin.data[3,2]-mean(preds$Homo_habilis)
hominin.data[4,4]<-hominin.data[4,2]-mean(preds$Homo_rudolfensis)
hominin.data[5,4]<-hominin.data[5,2]-mean(preds$Homo_sapiens)
hominin.data[6,4]<-hominin.data[6,2]-mean(preds$Homo_sapiens_neanderthalensis)
hominin.data[7,4]<-hominin.data[7,2]-mean(preds$Paranthropus_boisei)
hominin.data[8,4]<-hominin.data[8,2]-mean(preds$Paranthropus_robustus)
hominin.data[9,4]<-hominin.data[9,2]-mean(preds$Australopithecus_afarensis)



hominin.comparative.data<-comparative.data(sub.tree,hominin.data,Species)

brownian.model<-pgls(ECV.deviation~1,hominin.comparative.data)

directional.model<-pgls(ECV.deviation~divergence.times,hominin.comparative.data)

acceleration.model<-pgls(ECV.deviation~1,hominin.comparative.data,delta = 'ML',bounds = list(delta=c(1e-6,20)))

directional.acceleration.model<-pgls(ECV.deviation~divergence.times,hominin.comparative.data,delta = 'ML',bounds = list(delta=c(1e-6,20)))


AICcs<-c(brownian.model$aicc,directional.model$aicc,acceleration.model$aicc,directional.acceleration.model$aicc)
names(AICcs)<-c("brownain","directional","acceleration","directional acceleration")

plot(hominin.comparative.data$data$divergence.times,hominin.comparative.data$data$ECV.deviation,
     xlab=expression(paste("branch length from ",italic(Pan),"-hominin split (10"^"6"*" years)",sep="")),
     ylab=expression(paste("brain size deviaion (",log[10],"(mL))",sep="")),
     
     pch=c(0,1,2,5,6,3,10,4,8))

point.x=floor(par()$usr[1])+.4
text.x=floor(par()$usr[1])+.45
line.x=floor(par()$usr[1])+1

points(rep(point.x,times=9),c(.6,.58,.56,.54,.52,.50,.48,.46,.44),col=c("black","black","black","black","black","black","black","black","black","grey","grey","grey"),pch=c(8,4,10,3,6,5,2,1,0))
text(text.x,.6,labels="H. sapiens",font=3,cex=.8,offset=0,pos=4)
text(text.x,.58,labels="H. neanderthalensis",font=3,cex=.8,offset=0,pos=4)
text(text.x,.56,labels="H. erectus",font=3,cex=.8,offset=0,pos=4)
text(text.x,.54,labels="H. habilis",font=3,cex=.8,offset=0,pos=4)
text(text.x,.52,labels="H. rudolfensis",font=3,cex=.8,offset=0,pos=4)
text(text.x,.50,labels="A. africanus",font=3,cex=.8,offset=0,pos=4)
text(text.x,.48,labels="P. robustus",font=3,cex=.8,offset=0,pos=4)
text(text.x,.46,labels="P. boisei",font=3,cex=.8,offset=0,pos=4)
text(text.x,.44,labels="A. afarensis",font=3,cex=.8,offset=0,pos=4)

#curve(directional.model$model$coef[1]+directional.model$model$coef[2]*x,lty=2,add=T)
#curve(acceleration.model$model$coef[1]+x^acceleration.model$param[3],lty=3,add=T)
#curve(directional.acceleration.model$model$coef[1]+directional.acceleration.model$model$coef[2]*(x^directional.acceleration.model$param[3]),lty=4,add=T)

#segments(line.x,.6,line.x+.25,.6,lty=2)
#segments(line.x,.575,line.x+.25,.575,lty=3)
#segments(line.x,.55,line.x+.25,.55,lty=4)

#text(line.x+.3,.6,labels="directional model",pos=4,cex=.8,font = 1,offset = 0)
#text(line.x+.3,.575,labels="acceleration model",pos=4,cex=.8,font = 1,offset = 0)
#text(line.x+.3,.55,labels="directional acceleration model",pos=4,cex=.8,font = 1,offset = 0)

print(AICcs)

plot(rescale(drop.tip(sub.tree,"Pan_troglodytes"),model = "delta",directional.acceleration.model$param[3]))

